/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util.winreg;

import java.util.regex.Pattern;
import net.ftb.util.OSUtils;
import net.ftb.util.winreg.RuntimeStreamer;

public class JavaInfo
implements Comparable<JavaInfo> {
    public String path;
    public String version;
    public String origVersion = "";
    public boolean supportedVersion = false;
    public boolean hasJava8;
    public boolean is64bits;
    private int major;
    private int minor;
    private int revision;
    private int build;
    private static String regex = "[^\\d_.-]";

    public JavaInfo(String javaPath) {
        String versionInfo = RuntimeStreamer.execute(new String[]{javaPath, "-version"});
        String[] tokens = versionInfo.split("\"");
        this.version = tokens.length < 2 ? "0.0.0_00" : tokens[1];
        this.origVersion = this.version;
        this.version = Pattern.compile(regex).matcher(this.version).replaceAll("0");
        this.is64bits = versionInfo.toUpperCase().contains("64-");
        this.path = javaPath;
        String[] s = this.version.split("[._-]");
        this.major = Integer.parseInt(s[0]);
        this.minor = s.length > 1 ? Integer.parseInt(s[1]) : 0;
        this.revision = s.length > 2 ? Integer.parseInt(s[2]) : 0;
        int n = this.build = s.length > 3 ? Integer.parseInt(s[3]) : 0;
        if (OSUtils.getCurrentOS() == OSUtils.OS.MACOSX) {
            if (this.major == 1 && (this.minor == 7 || this.minor == 6)) {
                this.supportedVersion = true;
            }
        } else {
            this.supportedVersion = true;
        }
    }

    public JavaInfo(int major, int minor) {
        this.path = null;
        this.major = major;
        this.minor = minor;
        this.revision = 0;
        this.build = 0;
    }

    public boolean isJava8() {
        return this.major == 1 && this.minor == 8;
    }

    public String toString() {
        return "Java Version: " + this.origVersion + " sorted as: " + this.verToString() + " " + (this.is64bits ? "64" : "32") + " Bit Java at : " + this.path + (this.supportedVersion ? "" : " (UNSUPPORTED!)");
    }

    public String verToString() {
        return this.major + "." + this.minor + "." + this.revision + "_" + this.build;
    }

    @Override
    public int compareTo(JavaInfo o) {
        if (o.major > this.major) {
            return -1;
        }
        if (o.major < this.major) {
            return 1;
        }
        if (o.minor > this.minor) {
            return -1;
        }
        if (o.minor < this.minor) {
            return 1;
        }
        if (o.revision > this.revision) {
            return -1;
        }
        if (o.revision < this.revision) {
            return 1;
        }
        if (o.build > this.build) {
            return -1;
        }
        if (o.build < this.build) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getBuild() {
        return this.build;
    }
}

